/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import java.awt.Point;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXML_20_parser {
    VWXML_20_parser() {
    }

    protected static VWWorkflowDefinition parseXMLWorkflow(Element wfele) throws VWException, SAXException {
        NodeList childNodes;
        if (!wfele.getTagName().equals("WorkFlowDefinition")) {
            return null;
        }
        VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
        wfdef.setVersionAgnostic(false);
        wfdef.setValidateUsingSchema(false);
        if (wfele.getAttributeNode("Name") != null) {
            wfdef.setName(wfele.getAttribute("Name"));
        }
        if (wfele.getAttributeNode("Subject") != null) {
            wfdef.setSubject(wfele.getAttribute("Subject"));
        }
        if (wfele.getAttributeNode("Description") != null) {
            wfdef.setDescription(wfele.getAttribute("Description"));
        }
        if (wfele.getAttributeNode("MainAttachment") != null) {
            wfdef.setMainAttachmentNameNoValidate(wfele.getAttribute("MainAttachment"));
        }
        if (wfele.getAttributeNode("Deadline") != null) {
            wfdef.setDeadline(Long.parseLong(wfele.getAttribute("Deadline")));
        }
        if (wfele.getAttributeNode("Reminder") != null) {
            wfdef.setReminder(Long.parseLong(wfele.getAttribute("Reminder")));
        }
        if (wfele.getAttributeNode("BaseWorkClass") != null) {
            wfdef.setBaseWorkClassName(wfele.getAttribute("BaseWorkClass"));
        }
        if (wfele.getAttributeNode("Roster") != null) {
            wfdef.setRosterName(wfele.getAttribute("Roster"));
        }
        if (wfele.getAttributeNode("EventLog") != null) {
            wfdef.setEventLogName(wfele.getAttribute("EventLog"));
        }
        if ((childNodes = wfele.getChildNodes()) != null && childNodes.getLength() != 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node aNode = childNodes.item(i);
                if (aNode.getNodeName().equals("Field")) {
                    VWXML_20_parser.parseXMLFieldDefinition(aNode, wfdef);
                    continue;
                }
                if (!aNode.getNodeName().equals("Map")) continue;
                VWXML_20_parser.parseXMLMapDefinition(aNode, wfdef);
            }
        }
        return wfdef;
    }

    protected static void parseXMLFieldDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        String valueStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        int typeInt = VWFieldType.stringToType(ele.getAttribute("Type"));
        boolean isArrayBool = VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray"));
        int mergeInt = VWMergeType.stringToType(ele.getAttribute("MergeType"));
        VWFieldDefinition fldDef = nameStr != null && nameStr.equals("F_Trackers") ? wfdef.createFieldNoValidateName(nameStr, valueStr, typeInt, isArrayBool) : wfdef.createFieldUsingString(nameStr, valueStr, typeInt, isArrayBool);
        fldDef.setMergeType(mergeInt);
        if (ele.getAttributeNode("Description") != null) {
            fldDef.setDescription(ele.getAttribute("Description"));
        }
    }

    protected static void parseXMLMapDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException, SAXException, NumberFormatException {
        Element ele = (Element)aNode;
        NodeList childNodes = aNode.getChildNodes();
        String nameStr = ele.getAttribute("Name");
        VWMapDefinition map = wfdef.createEmptyMap(nameStr);
        if (ele.getAttributeNode("Description") != null) {
            map.setDescription(ele.getAttribute("Description"));
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Step")) continue;
            VWXML_20_parser.parseXMLStepDefinition(childNode, map);
        }
        if (ele.getAttributeNode("MaxStepId") != null) {
            int maxStepId = Integer.parseInt(ele.getAttribute("MaxStepId"));
            if (maxStepId >= map.findHighestStepId()) {
                map.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                map.updateNextStepId();
            }
        } else {
            map.updateNextStepId();
        }
    }

    protected static void parseXMLStepDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException {
        VWStepDefinition step = map.createEmptyStep();
        VWArrayHandler partHandler = new VWArrayHandler(1, 1);
        VWArrayHandler responseHandler = new VWArrayHandler(1, 1);
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            step.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("StepId") != null) {
            step.setStepId(Integer.parseInt(ele.getAttribute("StepId")));
        }
        if (ele.getAttributeNode("Description") != null) {
            step.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("QueueName") != null) {
            step.setQueueName(ele.getAttribute("QueueName"));
        }
        if (ele.getAttributeNode("RequestedInterface") != null) {
            step.setRequestedInterface(ele.getAttribute("RequestedInterface"));
        }
        if (ele.getAttributeNode("JoinStepId") != null) {
            step.setJoinStepId(Integer.parseInt(ele.getAttribute("JoinStepId")));
        }
        if (ele.getAttributeNode("JoinType") != null) {
            step.setJoinType(VWJoinType.stringToType(ele.getAttribute("JoinType")));
        }
        if (ele.getAttributeNode("SplitType") != null) {
            step.setSplitType(VWSplitType.stringToType(ele.getAttribute("SplitType")));
        }
        if (ele.getAttributeNode("CanReassign") != null) {
            step.setCanReassign(VWXMLHandler.stringToBoolean(ele.getAttribute("CanReassign")));
        }
        if (ele.getAttributeNode("CanViewStatus") != null) {
            step.setCanViewStatus(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewStatus")));
        }
        if (ele.getAttributeNode("Deadline") != null) {
            step.setDeadline(Long.parseLong(ele.getAttribute("Deadline")));
        }
        if (ele.getAttributeNode("Reminder") != null) {
            step.setReminder(Long.parseLong(ele.getAttribute("Reminder")));
        }
        String xcoordStr = null;
        String ycoordStr = null;
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            step.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Participant")) {
                step.setParticipants((VWParticipant[])partHandler.addElementToArray(step.getParticipants(), new VWParticipant(((Element)childNode).getAttribute("Val"))));
                continue;
            }
            if (childNode.getNodeName().equals("Response")) {
                step.setResponses((String[])responseHandler.addElementToArray(step.getResponses(), ((Element)childNode).getAttribute("Val")));
                continue;
            }
            if (childNode.getNodeName().equals("Parameter")) {
                VWXML_20_parser.parseXMLParameterDefinition(childNode, step);
                continue;
            }
            if (!childNode.getNodeName().equals("Route")) continue;
            VWXML_20_parser.parseXMLRouteDefinition(childNode, map);
        }
    }

    protected static void parseXMLRouteDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String condition = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("Condition") != null) {
            condition = ele.getAttribute("Condition");
        }
        VWMapNode step = map.getStep(Integer.parseInt(ele.getAttribute("SourceStepId")));
        VWRouteDefinition aRoute = step.createRoute(Integer.parseInt(ele.getAttribute("DestinationStepId")), condition, name);
        aRoute.setRelease(VWXMLHandler.stringToBoolean(ele.getAttribute("Release")));
    }

    protected static void parseXMLParameterDefinition(Node aNode, VWStepDefinition step) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String valueStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        VWParameterDefinition param = step.createParameter(name, VWModeType.stringToType(ele.getAttribute("Mode")), valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        if (ele.getAttributeNode("Description") != null) {
            param.setDescription(ele.getAttribute("Description"));
        }
    }
}

